/**
  ********************************************************************************
  *
  * @file    hal_irq.h
  * @brief   Header file of irq driver
  *
  * @version V1.0
  * @data    22 Aug 2018
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  ********************************************************************************
  */

#ifndef __HAL_IRQ_H__
#define __HAL_IRQ_H__

#include "hic.h"
#include "type.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @addtogroup IRQ
  * @{
  */

/**
  * @defgroup Irq_Public_Enums irq Public Enums
  * @{
  */

/**
  * @brief irq flag enum
  */
typedef enum {
	T20VIE_IT = 0,
	T20PIE_IT = 1,
	T10IE_IT  = 2,
	T21VIE_IT = 4,
	T21PIE_IT = 5,
	PIE0_IT   = 8,
	PIE1_IT   = 9,
	PIE2_IT   = 10,
	KIE_IT    = 15,
	TKIE_IT   = 16,
	IAPIE_IT  = 17,
	I2CIE_IT  = 18,
	ADIE_IT   = 19,
	LVDIE_IT  = 20,
	RX0IE_IT  = 21,
	TX0IE_IT  = 22,
	DIVIE_IT  = 23,
} hal_irq_t;

/**
  * @brief PINT Trigger Mode
  */
typedef enum {
	PINT_TRIGGER_RISING_EDGE    = 0,	/**< Rising edge */
	PINT_TRIGGER_FALLING_EDGE   = 1,	/**< Falling edge */
	PINT_TRIGGER_HIGH_LEVEL     = 2,	/**< High level */
	PINT_TRIGGER_LOW_LEVEL      = 3,	/**< Low level */
	PINT_TRIGGER_RISING_FALLING = 4,	/**< Falling and rising edge */
} pint_trig_t;

/**
  * @}
  */

/**
  * @defgroup Irq_Public_Micros irq Public Micros
  * @{
  */

#define IRQ_GIE_CFG(x)	(GIE = ((x) ? 1 : 0))
#define KEY_IRQ_MASK_CFG(x, y)	((x) ? (KMSK1 = (y)) : (KMSK0 = (y)))
/**
  * @}
  */
/**
  * @addtogroup Irq_Public_Functions
  * @{
  */

extern void irq_config(hal_irq_t type, type_func_t opt);
extern bit_status_t irq_get_it_status(hal_irq_t type);
extern bit_status_t irq_get_flag_status(hal_irq_t type);
extern void irq_clear_flag_status(hal_irq_t type);
extern void pint_trig_cfg(pint_trig_t mode);

/*
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#endif
